/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.Function;
import intrinsic.flash.display.DisplayObjectContainer;
import intrinsic.mx.collections.ArrayCollection;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.flex.SWTTreeDataDescriptor;
import org.eclipse.swt.events.*;

public class Tree extends Composite {
	ArrayCollection items;

public Tree (Composite parent, int style) {
	super (parent, checkStyle (style));
}

static int checkStyle (int style) {
	/*
	* To be compatible with Windows, force the H_SCROLL
	* and V_SCROLL style bits.  On Windows, it is not
	* possible to create a table without scroll bars.
	*/
	style |= SWT.H_SCROLL | SWT.V_SCROLL;
	/* Flex is always FULL_SELECTION */
	style |= SWT.FULL_SELECTION;
	return checkBits (style, SWT.SINGLE, SWT.MULTI, 0, 0, 0, 0);
}

void createItem (TreeItem item, TreeItem parentItem, int index) {
	ArrayCollection items = parentItem != null ? parentItem.items : this.items;
	int itemCount = items.length;
	if (!(0 <= index && index <= itemCount)) error (SWT.ERROR_INVALID_RANGE);
	item.createWidget();
	items.addItemAt(item, index);
}

boolean checkData (TreeItem item, boolean redraw) {
	if (item.cached) return true;
	if ((style & SWT.VIRTUAL) != 0) {
		item.cached = true;
		Event event = new Event ();
		TreeItem parentItem = item.getParentItem ();
		event.item = item;
		event.index = parentItem == null ? indexOf (item) : parentItem.indexOf (item);
//		ignoreRedraw = true;
		sendEvent (SWT.SetData, event);
		//widget could be disposed at this point
//		ignoreRedraw = false;
		if (isDisposed () || item.isDisposed ()) return false;
//		if (redraw) {
//			if (!setScrollWidth (item)) item.redraw (OS.kDataBrowserNoItem);
//		}
	}
	return true;
}

public void addSelectionListener (SelectionListener listener) {
}

public void addTreeListener (TreeListener listener) {
}

protected void checkSubclass () {
}

public void clear (int index, boolean all) {
}

public void clearAll (boolean all) {
}

void createHandle () {
	intrinsic.mx.controls.Tree widget = new intrinsic.mx.controls.Tree();
	if ((style & SWT.MULTI) != 0) widget.allowMultipleSelection = true;
	widget.dataProvider = items = new ArrayCollection();
//	widget.itemRenderer = new TableItemRendererClassFactory(this, null, false);
	widget.dataDescriptor = new SWTTreeDataDescriptor();
	widget.labelFunction = getLabelHandlerFunction();
	widget.iconFunction = getImageHandlerFunction();
	object = widget;
}

public void deselectAll () {
}

void destroyItem (TreeItem item) {
	int index = items.getItemIndex(item);
	items.removeItemAt(index);
}

public int getGridLineWidth () {
	return 0;
}

public int getHeaderHeight () {
	return 0;
}

public boolean getHeaderVisible () {
	return false;
}

public TreeColumn getColumn (int index) {
	checkWidget ();
	int count = 0;
	if (!(0 <= index && index < count)) error (SWT.ERROR_INVALID_RANGE);
	return null;
}

public int getColumnCount () {
	return 0;
}

public int[] getColumnOrder () {
	return null;
}

public TreeColumn[] getColumns () {
	checkWidget ();
	return new TreeColumn[0];
}

public TreeItem getItem (int index) {
	checkWidget ();
	if (!(0 <= index && index < items.length)) error (SWT.ERROR_INVALID_RANGE);
	return (TreeItem)items.getItemAt(index);
}

public TreeItem getItem (Point point) {
	return null;
}

public int getItemCount () {
	checkWidget();
	return items.length;
}

public int getItemHeight () {
	return 0;
}

public TreeItem[] getItems () {
	checkWidget ();
	TreeItem[] result = new TreeItem[items.length];
	for (int i = 0; i < result.length; i++) {
		result[i] = (TreeItem)items.getItemAt(i);
	}
	return result;
}

Image _getImage(DisplayObjectContainer item) {
	intrinsic.mx.controls.Tree widget = (intrinsic.mx.controls.Tree)object;
	for (int i = 0; i < items.length; i++) {
		//TODO not optimal
		if (widget.itemToItemRenderer(items.getItemAt(i)) == item) {
			TreeItem treeItem = (TreeItem)items.getItemAt(i);
			return treeItem.image;
		}
	}
	return null;
}

intrinsic.Class getImageHandler(Object object) {
	TreeItem item = (TreeItem)object;
	Image image = item.getImage();
	return image != null ? SWTBitmapAsset.getClazz() : null;
}

native Function getImageHandlerFunction ()/*{
	return getImageHandler__Ljava_lang_Object_2;
}*/;


String getLabelHandler(Object object) {
	TreeItem item = (TreeItem)object;
	return item.getText();
}

native Function getLabelHandlerFunction ()/*{
	return getLabelHandler__Ljava_lang_Object_2;
}*/;

public boolean getLinesVisible () {
	return false;
}

public TreeItem getParentItem () {
	return null;
}

public TreeItem[] getSelection () {
	return null;
}

public int getSelectionCount () {
	return 0;
}

public TreeColumn getSortColumn () {
	return null;
}

public int getSortDirection () {
	return 0;
}

public TreeItem getTopItem () {
	return null;
}

public int indexOf (TreeColumn column) {
	return 0;
}

public int indexOf (TreeItem item) {
	return 0;
}

void invalidateItem (TreeItem item, int columnIndex) {
//	//TODO figure out why this doesn't work
////	items.itemUpdated(item);
//	
//	SWTDataGrid dataGrid = (SWTDataGrid)object;
//	int rowIndex = items.getItemIndex(item);
//	Container renderer = (Container)dataGrid.getItemRenderer(rowIndex, columnIndex);
//	if (renderer != null) {
//		renderer.invalidateProperties();
//		renderer.invalidateDisplayList();
//	}
}

void releaseChildren (boolean destroy) {
	if (items != null) {
		int itemCount = items.length;
		for (int i=0; i<itemCount; i++) {
			TreeItem item = (TreeItem)items.getItemAt(i);
			if (item != null && !item.isDisposed ()) {
				item.release (false);
			}
		}
	}
//	if (columns != null) {
//		for (int i=0; i<columnCount; i++) {
//			TableColumn column = columns [i];
//			if (column != null && !column.isDisposed ()) {
//				column.release (false);
//			}
//		}
//		columns = null;
//	}
	super.releaseChildren (destroy);
}

void releaseWidget () {
	super.releaseWidget ();
	items = null;
}

public void removeAll () {
}

public void removeSelectionListener (SelectionListener listener) {
}

public void removeTreeListener (TreeListener listener) {
}

public void setInsertMark (TreeItem item, boolean before) {
}

public void setItemCount (int count) {
}

public void setLinesVisible (boolean show) {
}

public void selectAll () {
}

public void setColumnOrder (int[] order) {
}

public void setFont (Font font) {
}

public void setHeaderVisible (boolean show) {
}

public void setRedraw (boolean redraw) {
}

public void setSelection (TreeItem item) {
}

public void setSelection (TreeItem[] items) {
}

public void setSortColumn (TreeColumn column) {
}

public void setSortDirection (int direction) {
}

public void setTopItem (TreeItem item) {
}

public void showColumn (TreeColumn column) {
}

public void showItem (TreeItem item) {
}

public void showSelection () {
}

}
